class sgScore extends UnrealCTFScoreBoard;

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
    local float XL, YL, XL2, YL2, YB;
    local BotReplicationInfo BRI;
    local String S, O, L;
    local Font CanvasFont;
    local bool bAdminPlayer;
    local PlayerPawn PlayerOwner;
    local int Time;

    PlayerOwner = PlayerPawn(Owner);

    bAdminPlayer = PRI.bAdmin;

    // Draw Name
    if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
        Canvas.DrawColor = GoldColor;

    if ( bAdminPlayer )
        Canvas.DrawColor = WhiteColor;

    Canvas.SetPos(XOffset, YOffset);
    Canvas.DrawText(PRI.PlayerName, False);
    Canvas.StrLen(PRI.PlayerName, XL, YB);

    if ( Canvas.ClipX > 512 )
    {
        CanvasFont = Canvas.Font;
        Canvas.Font = Font'SmallFont';
        Canvas.DrawColor = WhiteColor;

        if (Level.NetMode != NM_Standalone)
        {
            if ( !bCompressed || (Canvas.ClipX > 640) )
            {
                // Draw Time
                Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
                Canvas.StrLen(TimeString$":     ", XL, YL);
                Canvas.SetPos(XOffset - XL - 6, YOffset);
                Canvas.DrawText(TimeString$":"@Time, false);
            }

            // Draw Ping
            Canvas.StrLen(PingString$":     ", XL2, YL2);
            Canvas.SetPos(XOffset - XL2 - 6, YOffset + (YL+1));
            Canvas.DrawText(PingString$":"@PRI.Ping, false);
        }
        Canvas.Font = CanvasFont;
    }

    // Draw Score
    if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
        Canvas.DrawColor = GoldColor;
    else
        Canvas.DrawColor = TeamColor[PRI.Team];
    DrawScore(Canvas, PRI.Score, XOffset, YOffset);

    if (Canvas.ClipX < 512)
        return;

    // Draw location, Order
    if ( !bCompressed && (PRI.Team == OwnerInfo.Team) )
    {
        CanvasFont = Canvas.Font;
        Canvas.Font = Font'SmallFont';

        if ( PRI.PlayerLocation != None )
            L = PRI.PlayerLocation.LocationName;
        else if ( PRI.PlayerZone != None )
            L = PRI.PlayerZone.ZoneName;
        else
            L = "";
        if ( L != "" )
        {
            L = InString@L;
            Canvas.SetPos(XOffset, YOffset + YB);
            Canvas.DrawText(L, False);
        }
        O = OwnerGame.GetOrderString(PRI);
        if (O != "")
        {
            O = OrdersString@O;
            Canvas.StrLen(O, XL2, YL2);
            Canvas.SetPos(XOffset, YOffset + YB + YL2);
            Canvas.DrawText(O, False);
        }
	O = "RU:"@int(sgPRI(PRI).RU);
	Canvas.StrLen(O, XL, YL);
	Canvas.SetPos(XOffset + (Canvas.ClipX/4) - XL, YOffset + YB );
	Canvas.DrawText(O, False);
        Canvas.Font = CanvasFont;
    }
}



function DrawTrailer( canvas Canvas )
{
    local int Hours, Minutes, Seconds;
    local float XL, YL, YOffset, XOffset;
    local PlayerPawn PlayerOwner;
    local int i, nPC;
    local string sNames[32];
    local PlayerReplicationInfo PRI;
    local font CanvasFont;

    Super.DrawTrailer( Canvas );

    sNames[0]="Siege Spectators";
    sNames[1]="______________";
    nPC+=2;
    for ( i=0; i<32; i++ )
        if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
	{
            PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
            if ( (PRI.bIsSpectator || PRI.bWaitingPlayer ) && PRI.PlayerName!="Player")
            {
                sNames[nPC]=PRI.PlayerName;
                nPC++;
            }
	}
    if (nPC==2)
	sNames[nPC++]="None";

    Canvas.bCenter = true;
    Canvas.StrLen("Test", XL, YL);
    Canvas.DrawColor = WhiteColor;

    XOffset = 0; //Canvas.ClipX/2;
    YOffset = Canvas.ClipY - (4 * YL) -4;

    CanvasFont = Canvas.Font;
    Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
    YOffset-= (nPC * YL);

    for ( i=0; i<nPC; i++ )
    {
        Canvas.StrLen(sNames[i], XL, YL);
    	Canvas.SetPos(XOffset, YOffset + (i * YL));
    	//Canvas.SetPos(XOffset-(XL/2), YOffset + (i * YL));
	Canvas.DrawText(sNames[i], True);
    }
    Canvas.bCenter = false;
    Canvas.Font=CanvasFont;
}


